/**
 * Secure Hash Algorithm with 256-bit digest (SHA-256) implementation.
 *
 * See FIPS 180-2 for details.
 *
 * @author Dave Longley
 *
 * Copyright (c) 2010-2015 Digital Bazaar, Inc.
 */

var forge={};
 
(function(){/*function c(q){*/var q=forge;var l=q.util=q.util||{};if(typeof process==="undefined"||!process.nextTick){if(typeof setImmediate==="function"){l.setImmediate=setImmediate;l.nextTick=function(s){return setImmediate(s)}}else{l.setImmediate=function(s){setTimeout(s,0)};l.nextTick=l.setImmediate}}else{l.nextTick=process.nextTick;if(typeof setImmediate==="function"){l.setImmediate=setImmediate}else{l.setImmediate=l.nextTick}}l.isArray=Array.isArray||function(s){return Object.prototype.toString.call(s)==="[object Array]"};l.ByteBuffer=function(s){this.data=s||"";this.read=0};l.ByteBuffer.prototype.length=function(){return this.data.length-this.read};l.ByteBuffer.prototype.isEmpty=function(){return this.length()<=0};l.ByteBuffer.prototype.putByte=function(s){this.data+=String.fromCharCode(s);return this};l.ByteBuffer.prototype.fillWithByte=function(s,u){s=String.fromCharCode(s);var t=this.data;while(u>0){if(u&1){t+=s}u>>>=1;if(u>0){s+=s}}this.data=t;return this};l.ByteBuffer.prototype.putBytes=function(s){this.data+=s;return this};l.ByteBuffer.prototype.putString=function(s){this.data+=l.encodeUtf8(s);return this};l.ByteBuffer.prototype.putInt16=function(s){this.data+=String.fromCharCode(s>>8&255)+String.fromCharCode(s&255);return this};l.ByteBuffer.prototype.putInt24=function(s){this.data+=String.fromCharCode(s>>16&255)+String.fromCharCode(s>>8&255)+String.fromCharCode(s&255);return this};l.ByteBuffer.prototype.putInt32=function(s){this.data+=String.fromCharCode(s>>24&255)+String.fromCharCode(s>>16&255)+String.fromCharCode(s>>8&255)+String.fromCharCode(s&255);return this};l.ByteBuffer.prototype.putInt16Le=function(s){this.data+=String.fromCharCode(s&255)+String.fromCharCode(s>>8&255);return this};l.ByteBuffer.prototype.putInt24Le=function(s){this.data+=String.fromCharCode(s&255)+String.fromCharCode(s>>8&255)+String.fromCharCode(s>>16&255);return this};l.ByteBuffer.prototype.putInt32Le=function(s){this.data+=String.fromCharCode(s&255)+String.fromCharCode(s>>8&255)+String.fromCharCode(s>>16&255)+String.fromCharCode(s>>24&255);return this};l.ByteBuffer.prototype.putInt=function(s,t){do{t-=8;this.data+=String.fromCharCode((s>>t)&255)}while(t>0);return this};l.ByteBuffer.prototype.putSignedInt=function(s,t){if(s<0){s+=2<<(t-1)}return this.putInt(s,t)};l.ByteBuffer.prototype.putBuffer=function(s){this.data+=s.getBytes();return this};l.ByteBuffer.prototype.getByte=function(){return this.data.charCodeAt(this.read++)};l.ByteBuffer.prototype.getInt16=function(){var s=(this.data.charCodeAt(this.read)<<8^this.data.charCodeAt(this.read+1));this.read+=2;return s};l.ByteBuffer.prototype.getInt24=function(){var s=(this.data.charCodeAt(this.read)<<16^this.data.charCodeAt(this.read+1)<<8^this.data.charCodeAt(this.read+2));this.read+=3;return s};l.ByteBuffer.prototype.getInt32=function(){var s=(this.data.charCodeAt(this.read)<<24^this.data.charCodeAt(this.read+1)<<16^this.data.charCodeAt(this.read+2)<<8^this.data.charCodeAt(this.read+3));this.read+=4;return s};l.ByteBuffer.prototype.getInt16Le=function(){var s=(this.data.charCodeAt(this.read)^this.data.charCodeAt(this.read+1)<<8);this.read+=2;return s};l.ByteBuffer.prototype.getInt24Le=function(){var s=(this.data.charCodeAt(this.read)^this.data.charCodeAt(this.read+1)<<8^this.data.charCodeAt(this.read+2)<<16);this.read+=3;return s};l.ByteBuffer.prototype.getInt32Le=function(){var s=(this.data.charCodeAt(this.read)^this.data.charCodeAt(this.read+1)<<8^this.data.charCodeAt(this.read+2)<<16^this.data.charCodeAt(this.read+3)<<24);this.read+=4;return s};l.ByteBuffer.prototype.getInt=function(t){var s=0;do{s=(s<<8)+this.data.charCodeAt(this.read++);t-=8}while(t>0);return s};l.ByteBuffer.prototype.getSignedInt=function(u){var t=this.getInt(u);var s=2<<(u-2);if(t>=s){t-=s<<1}return t};l.ByteBuffer.prototype.getBytes=function(s){var t;if(s){s=Math.min(this.length(),s);t=this.data.slice(this.read,this.read+s);this.read+=s}else{if(s===0){t=""}else{t=(this.read===0)?this.data:this.data.slice(this.read);this.clear()}}return t};l.ByteBuffer.prototype.bytes=function(s){return(typeof(s)==="undefined"?this.data.slice(this.read):this.data.slice(this.read,this.read+s))};l.ByteBuffer.prototype.at=function(s){return this.data.charCodeAt(this.read+s)};l.ByteBuffer.prototype.setAt=function(t,s){this.data=this.data.substr(0,this.read+t)+String.fromCharCode(s)+this.data.substr(this.read+t+1);return this};l.ByteBuffer.prototype.last=function(){return this.data.charCodeAt(this.data.length-1)};l.ByteBuffer.prototype.copy=function(){var s=l.createBuffer(this.data);s.read=this.read;return s};l.ByteBuffer.prototype.compact=function(){if(this.read>0){this.data=this.data.slice(this.read);this.read=0}return this};l.ByteBuffer.prototype.clear=function(){this.data="";this.read=0;return this};l.ByteBuffer.prototype.truncate=function(t){var s=Math.max(0,this.length()-t);this.data=this.data.substr(this.read,s);this.read=0;return this};l.ByteBuffer.prototype.toHex=function(){var u="";for(var t=this.read;t<this.data.length;++t){var s=this.data.charCodeAt(t);if(s<16){u+="0"}u+=s.toString(16)}return u};l.ByteBuffer.prototype.toString=function(){return l.decodeUtf8(this.bytes())};l.createBuffer=function(s,t){t=t||"raw";if(s!==undefined&&t==="utf8"){s=l.encodeUtf8(s)}return new l.ByteBuffer(s)};l.fillString=function(v,u){var t="";while(u>0){if(u&1){t+=v}u>>>=1;if(u>0){v+=v}}return t};l.xorBytes=function(y,v,A){var u="";var s="";var x="";var w=0;var z=0;for(;A>0;--A,++w){s=y.charCodeAt(w)^v.charCodeAt(w);if(z>=10){u+=x;x="";z=0}x+=String.fromCharCode(s);++z}u+=x;return u};l.hexToBytes=function(t){var u="";var s=0;if(t.length&1==1){s=1;u+=String.fromCharCode(parseInt(t[0],16))}for(;s<t.length;s+=2){u+=String.fromCharCode(parseInt(t.substr(s,2),16))}return u};l.bytesToHex=function(s){return l.createBuffer(s).toHex()};l.int32ToBytes=function(s){return(String.fromCharCode(s>>24&255)+String.fromCharCode(s>>16&255)+String.fromCharCode(s>>8&255)+String.fromCharCode(s&255))};var g="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var r=[62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,64,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51];l.encode64=function(v,z){var s="";var u="";var y,w,t;var x=0;while(x<v.length){y=v.charCodeAt(x++);w=v.charCodeAt(x++);t=v.charCodeAt(x++);s+=g.charAt(y>>2);s+=g.charAt(((y&3)<<4)|(w>>4));if(isNaN(w)){s+="=="}else{s+=g.charAt(((w&15)<<2)|(t>>6));s+=isNaN(t)?"=":g.charAt(t&63)}if(z&&s.length>z){u+=s.substr(0,z)+"\r\n";s=s.substr(z)}}u+=s;return u};l.decode64=function(t){t=t.replace(/[^A-Za-z0-9\+\/\=]/g,"");var s="";var y,x,w,v;var u=0;while(u<t.length){y=r[t.charCodeAt(u++)-43];x=r[t.charCodeAt(u++)-43];w=r[t.charCodeAt(u++)-43];v=r[t.charCodeAt(u++)-43];s+=String.fromCharCode((y<<2)|(x>>4));if(w!==64){s+=String.fromCharCode(((x&15)<<4)|(w>>2));if(v!==64){s+=String.fromCharCode(((w&3)<<6)|v)}}}return s};l.encodeUtf8=function(s){return unescape(encodeURIComponent(s))};l.decodeUtf8=function(s){return decodeURIComponent(escape(s))};l.deflate=function(v,t,u){t=l.decode64(v.deflate(l.encode64(t)).rval);if(u){var w=2;var s=t.charCodeAt(1);if(s&32){w=6}t=t.substring(w,t.length-4)}return t};l.inflate=function(u,s,t){var v=u.inflate(l.encode64(s)).rval;return(v===null)?null:l.decode64(v)};var i=function(s,v,u){if(!s){throw {message:"WebStorage not available."}}var t;if(u===null){t=s.removeItem(v)}else{u=l.encode64(JSON.stringify(u));t=s.setItem(v,u)}if(typeof(t)!=="undefined"&&t.rval!==true){throw t.error}};var k=function(s,u){if(!s){throw {message:"WebStorage not available."}}var t=s.getItem(u);if(s.init){if(t.rval===null){if(t.error){throw t.error}t=null}else{t=t.rval}}if(t!==null){t=JSON.parse(l.decode64(t))}return t};var p=function(t,w,s,u){var v=k(t,w);if(v===null){v={}}v[s]=u;i(t,w,v)};var h=function(t,v,s){var u=k(t,v);if(u!==null){u=(s in u)?u[s]:null}return u};var j=function(t,x,s){var v=k(t,x);if(v!==null&&s in v){delete v[s];var u=true;for(var w in v){u=false;break}if(u){v=null}i(t,x,v)}};var n=function(s,t){i(s,t,null)};var m=function(t,x,z){var v=null;if(typeof(z)==="undefined"){z=["web","flash"]}var y;var u=false;var s=null;for(var A in z){y=z[A];try{if(y==="flash"||y==="both"){if(x[0]===null){throw {message:"Flash local storage not available."}}else{v=t.apply(this,x);u=(y==="flash")}}if(y==="web"||y==="both"){x[0]=localStorage;v=t.apply(this,x);u=true}}catch(w){s=w}if(u){break}}if(!u){throw s}return v};l.setItem=function(u,w,t,v,s){m(p,arguments,s)};l.getItem=function(u,v,t,s){return m(h,arguments,s)};l.removeItem=function(u,v,t,s){m(j,arguments,s)};l.clearItems=function(t,u,s){m(n,arguments,s)};l.parseUrl=function(v){var u=/^(https?):\/\/([^:&^\/]*):?(\d*)(.*)$/g;u.lastIndex=0;var s=u.exec(v);var t=(s===null)?null:{full:v,scheme:s[1],host:s[2],port:s[3],path:s[4]};if(t){t.fullHost=t.host;if(t.port){if(t.port!==80&&t.scheme==="http"){t.fullHost+=":"+t.port}else{if(t.port!==443&&t.scheme==="https"){t.fullHost+=":"+t.port}}}else{if(t.scheme==="http"){t.port=80}else{if(t.scheme==="https"){t.port=443}}}t.full=t.scheme+"://"+t.fullHost}return t};var o=null;l.getQueryVariables=function(s){var u=function(y){var z={};var x=y.split("&");for(var w=0;w<x.length;w++){var B=x[w].indexOf("=");var v;var A;if(B>0){v=x[w].substring(0,B);A=x[w].substring(B+1)}else{v=x[w];A=null}if(!(v in z)){z[v]=[]}if(!(v in Object.prototype)&&A!==null){z[v].push(unescape(A))}}return z};var t;if(typeof(s)==="undefined"){if(o===null){if(typeof(window)==="undefined"){o={}}else{o=u(window.location.search.substring(1))}}t=o}else{t=u(s)}return t};l.parseFragment=function(u){var t=u;var s="";var x=u.indexOf("?");if(x>0){t=u.substring(0,x);s=u.substring(x+1)}var w=t.split("/");if(w.length>0&&w[0]===""){w.shift()}var v=(s==="")?{}:l.getQueryVariables(s);return{pathString:t,queryString:s,path:w,query:v}};l.makeRequest=function(t){var u=l.parseFragment(t);var s={path:u.pathString,query:u.queryString,getPath:function(v){return(typeof(v)==="undefined")?u.path:u.path[v]},getQuery:function(v,w){var x;if(typeof(v)==="undefined"){x=u.query}else{x=u.query[v];if(x&&typeof(w)!=="undefined"){x=x[w]}}return x},getQueryLast:function(w,v){var y;var x=s.getQuery(w);if(x){y=x[x.length-1]}else{y=v}return y}};return s};l.makeLink=function(v,u,t){v=jQuery.isArray(v)?v.join("/"):v;var s=jQuery.param(u||{});t=t||"";return v+((s.length>0)?("?"+s):"")+((t.length>0)?("#"+t):"")};l.setPath=function(u,x,y){if(typeof(u)==="object"&&u!==null){var v=0;var t=x.length;while(v<t){var w=x[v++];if(v==t){u[w]=y}else{var s=(w in u);if(!s||(s&&typeof(u[w])!=="object")||(s&&u[w]===null)){u[w]={}}u=u[w]}}}};l.getPath=function(v,y,u){var w=0;var t=y.length;var s=true;while(s&&w<t&&typeof(v)==="object"&&v!==null){var x=y[w++];s=x in v;if(s){v=v[x]}}return(s?v:u)};l.deletePath=function(t,w){if(typeof(t)==="object"&&t!==null){var u=0;var s=w.length;while(u<s){var v=w[u++];if(u==s){delete t[v]}else{if(!(v in t)||(typeof(t[v])!=="object")||(t[v]===null)){break}t=t[v]}}}};l.isEmpty=function(s){for(var t in s){if(s.hasOwnProperty(t)){return false}}return true};l.format=function(z){var v=/%./g;var u;var t;var s=0;var y=[];var x=0;while((u=v.exec(z))){t=z.substring(x,v.lastIndex-2);if(t.length>0){y.push(t)}x=v.lastIndex;var w=u[0][1];switch(w){case"s":case"o":if(s<arguments.length){y.push(arguments[s+++1])}else{y.push("<?>")}break;case"%":y.push("%");break;default:y.push("<%"+w+"?>")}}y.push(z.substring(x));return y.join("")};l.formatNumber=function(x,v,C,w){var u=x,B=isNaN(v=Math.abs(v))?2:v;var A=C===undefined?",":C;var D=w===undefined?".":w,E=u<0?"-":"";var z=parseInt((u=Math.abs(+u||0).toFixed(B)),10)+"";var y=(z.length>3)?z.length%3:0;return E+(y?z.substr(0,y)+D:"")+z.substr(y).replace(/(\d{3})(?=\d)/g,"$1"+D)+(B?A+Math.abs(u-z).toFixed(B).slice(2):"")};l.formatSize=function(s){if(s>=1073741824){s=l.formatNumber(s/1073741824,2,".","")+" GiB"}else{if(s>=1048576){s=l.formatNumber(s/1048576,2,".","")+" MiB"}else{if(s>=1024){s=l.formatNumber(s/1024,0)+" KiB"}else{s=l.formatNumber(s,0)+" bytes"}}}return s};l.bytesFromIP=function(s){if(s.indexOf(".")!==-1){return l.bytesFromIPv4(s)}if(s.indexOf(":")!==-1){return l.bytesFromIPv6(s)}return null};l.bytesFromIPv4=function(v){v=v.split(".");if(v.length!==4){return null}var s=l.createBuffer();for(var u=0;u<v.length;++u){var t=parseInt(v[u],10);if(isNaN(t)){return null}s.putByte(t)}return s.getBytes()};l.bytesFromIPv6=function(x){var w=0;x=x.split(":").filter(function(y){if(y.length===0){++w}return true});var u=(8-x.length+w)*2;var s=l.createBuffer();for(var v=0;v<8;++v){if(!x[v]||x[v].length===0){s.fillWithByte(0,u);u=0;continue}var t=l.hexToBytes(x[v]);if(t.length<2){s.putByte(0)}s.putBytes(t)}return s.getBytes()};l.bytesToIP=function(s){if(s.length===4){return l.bytesToIPv4(s)}if(s.length===16){return l.bytesToIPv6(s)}return null};l.bytesToIPv4=function(s){if(s.length!==4){return null}var u=[];for(var t=0;t<s.length;++t){u.push(s.charCodeAt(t))}return u.join(".")};l.bytesToIPv6=function(A){if(A.length!==16){return null}var u=[];var z=[];var v=0;for(var t=0;t<A.length;t+=2){var s=l.bytesToHex(A[t]+A[t+1]);while(s[0]==="0"&&s!=="0"){s=s.substr(1)}if(s==="0"){var y=z[z.length-1];var w=u.length;if(!y||w!==y.end+1){z.push({start:w,end:w})}else{y.end=w;if((y.end-y.start)>(z[v].end-z[v].start)){v=z.length-1}}}u.push(s)}if(z.length>0){var x=z[v];if(x.end-x.start>0){u.splice(x.start,x.end-x.start+1,"");if(x.start===0){u.unshift("")}if(x.end===7){u.push("")}}}return u.join(":")}})()

 
var sha256 = forge.sha256 = forge.sha256 || {};
forge.md = forge.md || {};
forge.md.algorithms = forge.md.algorithms || {};
forge.md.sha256 = forge.md.algorithms.sha256 = sha256;

/**
 * Creates a SHA-256 message digest object.
 *
 * @return a message digest object.
 */
sha256.create = function() {
  // do initialization as necessary
  if(!_initialized) {
    _init();
  }

  // SHA-256 state contains eight 32-bit integers
  var _state = null;

  // input buffer
  var _input = forge.util.createBuffer();

  // used for word storage
  var _w = new Array(64);

  // message digest object
  var md = {
    algorithm: 'sha256',
    blockLength: 64,
    digestLength: 32,
    // 56-bit length of message so far (does not including padding)
    messageLength: 0,
    // true message length
    fullMessageLength: null,
    // size of message length in bytes
    messageLengthSize: 8
  };

  /**
   * Starts the digest.
   *
   * @return this digest object.
   */
  md.start = function() {
    // up to 56-bit message length for convenience
    md.messageLength = 0;

    // full message length (set md.messageLength64 for backwards-compatibility)
    md.fullMessageLength = md.messageLength64 = [];
    var int32s = md.messageLengthSize / 4;
    for(var i = 0; i < int32s; ++i) {
      md.fullMessageLength.push(0);
    }
    _input = forge.util.createBuffer();
    _state = {
      h0: 0x6A09E667,
      h1: 0xBB67AE85,
      h2: 0x3C6EF372,
      h3: 0xA54FF53A,
      h4: 0x510E527F,
      h5: 0x9B05688C,
      h6: 0x1F83D9AB,
      h7: 0x5BE0CD19
    };
    return md;
  };
  // start digest automatically for first time
  md.start();

  /**
   * Updates the digest with the given message input. The given input can
   * treated as raw input (no encoding will be applied) or an encoding of
   * 'utf8' maybe given to encode the input using UTF-8.
   *
   * @param msg the message input to update with.
   * @param encoding the encoding to use (default: 'raw', other: 'utf8').
   *
   * @return this digest object.
   */
  md.update = function(msg, encoding) {
    if(encoding === 'utf8') {
      msg = forge.util.encodeUtf8(msg);
    }

    // update message length
    var len = msg.length;
    md.messageLength += len;
    len = [(len / 0x100000000) >>> 0, len >>> 0];
    for(var i = md.fullMessageLength.length - 1; i >= 0; --i) {
      md.fullMessageLength[i] += len[1];
      len[1] = len[0] + ((md.fullMessageLength[i] / 0x100000000) >>> 0);
      md.fullMessageLength[i] = md.fullMessageLength[i] >>> 0;
      len[0] = ((len[1] / 0x100000000) >>> 0);
    }

    // add bytes to input buffer
    _input.putBytes(msg);

    // process bytes
    _update(_state, _w, _input);

    // compact input buffer every 2K or if empty
    if(_input.read > 2048 || _input.length() === 0) {
      _input.compact();
    }

    return md;
  };

  /**
   * Produces the digest.
   *
   * @return a byte buffer containing the digest value.
   */
  md.digest = function() {
    /* Note: Here we copy the remaining bytes in the input buffer and
    add the appropriate SHA-256 padding. Then we do the final update
    on a copy of the state so that if the user wants to get
    intermediate digests they can do so. */

    /* Determine the number of bytes that must be added to the message
    to ensure its length is congruent to 448 mod 512. In other words,
    the data to be digested must be a multiple of 512 bits (or 128 bytes).
    This data includes the message, some padding, and the length of the
    message. Since the length of the message will be encoded as 8 bytes (64
    bits), that means that the last segment of the data must have 56 bytes
    (448 bits) of message and padding. Therefore, the length of the message
    plus the padding must be congruent to 448 mod 512 because
    512 - 128 = 448.
    In order to fill up the message length it must be filled with
    padding that begins with 1 bit followed by all 0 bits. Padding
    must *always* be present, so if the message length is already
    congruent to 448 mod 512, then 512 padding bits must be added. */

    var finalBlock = forge.util.createBuffer();
    finalBlock.putBytes(_input.bytes());
	/*
    // compute remaining size to be digested (include message length size)
    var remaining = (
      md.fullMessageLength[md.fullMessageLength.length - 1] +
      md.messageLengthSize);

    // add padding for overflow blockSize - overflow
    // _padding starts with 1 byte with first bit is set (byte value 128), then
    // there may be up to (blockSize - 1) other pad bytes
    var overflow = remaining & (md.blockLength - 1);
    finalBlock.putBytes(_padding.substr(0, md.blockLength - overflow));

    // serialize message length in bits in big-endian order; since length
    // is stored in bytes we multiply by 8 and add carry from next int
    var next, carry;
    var bits = md.fullMessageLength[0] * 8;
    for(var i = 0; i < md.fullMessageLength.length - 1; ++i) {
      next = md.fullMessageLength[i + 1] * 8;
      carry = (next / 0x100000000) >>> 0;
      bits += carry;
      finalBlock.putInt32(bits >>> 0);
      bits = next >>> 0;
    }
    finalBlock.putInt32(bits);
	*/
    var s2 = {
      h0: _state.h0,
      h1: _state.h1,
      h2: _state.h2,
      h3: _state.h3,
      h4: _state.h4,
      h5: _state.h5,
      h6: _state.h6,
      h7: _state.h7
    };
    _update(s2, _w, finalBlock);
    var rval = forge.util.createBuffer();
    rval.putInt32(s2.h0);
    rval.putInt32(s2.h1);
    rval.putInt32(s2.h2);
    rval.putInt32(s2.h3);
    rval.putInt32(s2.h4);
    rval.putInt32(s2.h5);
    rval.putInt32(s2.h6);
    rval.putInt32(s2.h7);
    return rval;
  };

  return md;
};

// sha-256 padding bytes not initialized yet
var _padding = null;
var _initialized = false;

// table of constants
var _k = null;

/**
 * Initializes the constant tables.
 */
function _init() {
  // create padding
  _padding = String.fromCharCode(128);
  _padding += forge.util.fillString(String.fromCharCode(0x00), 64);

  // create K table for SHA-256
  _k = [
    0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
    0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
    0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
    0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
    0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
    0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
    0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
    0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
    0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
    0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
    0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
    0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
    0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
    0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
    0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
    0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];

  // now initialized
  _initialized = true;
}

/**
 * Updates a SHA-256 state with the given byte buffer.
 *
 * @param s the SHA-256 state to update.
 * @param w the array to use to store words.
 * @param bytes the byte buffer to update with.
 */
function _update(s, w, bytes) {
  // consume 512 bit (64 byte) chunks
  var t1, t2, s0, s1, ch, maj, i, a, b, c, d, e, f, g, h;
  var len = bytes.length();
  while(len >= 64) {
    // the w array will be populated with sixteen 32-bit big-endian words
    // and then extended into 64 32-bit words according to SHA-256
    for(i = 0; i < 16; ++i) {
      w[i] = bytes.getInt32();
    }
    for(; i < 64; ++i) {
      // XOR word 2 words ago rot right 17, rot right 19, shft right 10
      t1 = w[i - 2];
      t1 =
        ((t1 >>> 17) | (t1 << 15)) ^
        ((t1 >>> 19) | (t1 << 13)) ^
        (t1 >>> 10);
      // XOR word 15 words ago rot right 7, rot right 18, shft right 3
      t2 = w[i - 15];
      t2 =
        ((t2 >>> 7) | (t2 << 25)) ^
        ((t2 >>> 18) | (t2 << 14)) ^
        (t2 >>> 3);
      // sum(t1, word 7 ago, t2, word 16 ago) modulo 2^32
      w[i] = (t1 + w[i - 7] + t2 + w[i - 16]) | 0;
    }

    // initialize hash value for this chunk
    a = s.h0;
    b = s.h1;
    c = s.h2;
    d = s.h3;
    e = s.h4;
    f = s.h5;
    g = s.h6;
    h = s.h7;

    // round function
    for(i = 0; i < 64; ++i) {
      // Sum1(e)
      s1 =
        ((e >>> 6) | (e << 26)) ^
        ((e >>> 11) | (e << 21)) ^
        ((e >>> 25) | (e << 7));
      // Ch(e, f, g) (optimized the same way as SHA-1)
      ch = g ^ (e & (f ^ g));
      // Sum0(a)
      s0 =
        ((a >>> 2) | (a << 30)) ^
        ((a >>> 13) | (a << 19)) ^
        ((a >>> 22) | (a << 10));
      // Maj(a, b, c) (optimized the same way as SHA-1)
      maj = (a & b) | (c & (a ^ b));

      // main algorithm
      t1 = h + s1 + ch + _k[i] + w[i];
      t2 = s0 + maj;
      h = g;
      g = f;
      f = e;
      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
      // can't truncate with `| 0`
      e = (d + t1) >>> 0;
      d = c;
      c = b;
      b = a;
      // `>>> 0` necessary to avoid iOS/Safari 10 optimization bug
      // can't truncate with `| 0`
      a = (t1 + t2) >>> 0;
    }

    // update hash state
    s.h0 = (s.h0 + a) | 0;
    s.h1 = (s.h1 + b) | 0;
    s.h2 = (s.h2 + c) | 0;
    s.h3 = (s.h3 + d) | 0;
    s.h4 = (s.h4 + e) | 0;
    s.h5 = (s.h5 + f) | 0;
    s.h6 = (s.h6 + g) | 0;
    s.h7 = (s.h7 + h) | 0;
    len -= 64;
  }
}

/*
var SHA256Compress=function(buf) {
	var hash=sha256.create();
	hash.update(buf.toString('ascii'));
	return new Buffer(hash.digest().data,'ascii');
};
*/

var SHA256Compress=function(buf) {
	//stupid manipulations because of stupid deprecation of binary format in nodejs
	var hash=sha256.create();
	hash.update(String.fromCharCode.apply(null,buf));
	var hash=hash.digest().data;
	var l=hash.length;
	var b=new Buffer(l);
	for (var i=0;i<l;i++) {
		b[i]=hash.charCodeAt(i);
	};
	return b;
};

module.exports=SHA256Compress;

/*
var buf=new Buffer('00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000','hex');
var buf=Buffer.concat([new Buffer('c65e8ed445c3e6456320735348c9835a3e7265de13655c549dbdbce2ad0dec2d','hex'),new Buffer('0000000000000000000000000000000000000000000000000000000000000000','hex')])
var hash=sha256.create();
hash.update(buf.toString('binary'));
console.log(new Buffer(hash.digest().data,'binary').toString('hex'));
*/

/* tests
var buf=Buffer.concat([new Buffer('c65e8ed445c3e6456320735348c9835a3e7265de13655c549dbdbce2ad0dec2d','hex'),new Buffer('0000000000000000000000000000000000000000000000000000000000000000','hex')])
console.log(SHA256Compress(buf).toString('hex'));
//9a20b2f42391d61fa598dce28efe02e755ea06cc10d498e6124a1df9480c4f00
*/